% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{dstem}
\alias{dstem}
\title{Detection of change points based on 'dSTEM' algorithm}
\usage{
dstem(
  data,
  type = c("I", "II-step", "II-linear", "mixture"),
  gamma = 20,
  alpha = 0.05
)
}
\arguments{
\item{data}{vector of data sequence}

\item{type}{"I" if the change points are piecewise linear and continuous;
"II-step" if the change points are piecewise constant and noncontinuous;
"II-linear" if the change points are piecewise linear and noncontinuous;
"mixture" if both type I and type II change points are include in \code{data}}

\item{gamma}{bandwidth of Gaussian kernel}

\item{alpha}{global significant level}
}
\value{
if type is 'mixture', the output is a list of type I and type II change points,
        otherwise, it is a list of change points
}
\description{
Detection of change points based on 'dSTEM' algorithm
}
\examples{
## piecewise linear signal
l = 1200
h = seq(150,by=150,length.out=6)
jump = rep(0,7)
beta1 = c(2,-1,2.5,-3,-0.2,2.5)/50
beta1 = c(beta1,-sum(beta1*(c(h[1],diff(h))))/(l-tail(h,1)))
signal = gen.signal(l,h,jump,beta1)
noise = rnorm(length(signal),0,1)
gamma = 25
model = dstem(signal + noise,"I",gamma=gamma,alpha=0.05)
## piecewise constant
l = 1200
h = seq(150,by=150,length.out=6)
jump = c(0,1.5,2,2.2,1.8,2,1.5)
beta1 = rep(0,length(h)+1)
signal = gen.signal(l,h,jump,beta1)
noise = rnorm(length(signal),0,1)
gamma = 25
model = dstem(signal + noise, "II-step",gamma,alpha=0.05)
## piecewise linear with jump
l = 1200
h = seq(150,by=150,length.out=6)
jump = c(0,1.5,2,2.2,1.8,2,1.5)*3
beta1 = c(2,-1,2.5,-3,-0.2,2.5,-0.5)/50
signal = gen.signal(l=l,h=h,jump=jump,b1=beta1)
noise = rnorm(length(signal),0,1)
gamma = 25
model = dstem(signal + noise, "II-linear",gamma,alpha=0.05)
}
\seealso{
\code{\link{cpTest}}
}
