% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_rot_combine.R
\docType{class}
\name{cyl_rot_combine-class}
\alias{cyl_rot_combine-class}
\title{An S4 Class of Circular-Linear Copulas generated from Linear Combinations
 of Copulas}
\description{
This class contains bivariate circular-linear copulas, generated from
linear-linear bivariate '\code{\link[copula:Copula-class]{Copula}}' objects of the package
'\pkg{copula}', by taking the arithmetic mean of the original copula and
the 90 deg rotated copula. This results in copulas that are periodic in the
circular dimension, u, and symmetric with respect to \eqn{u=0.5}, i.e. positive
and negative angles.
}
\section{Slots}{

\describe{
\item{\code{name}}{\link[base]{character} string holding the name of the copula.}

\item{\code{parameters}}{\link[base]{numeric} \link[base]{vector} holding the parameter values.}

\item{\code{param.names}}{\link[base]{character} \link[base]{vector} the parameter names.}

\item{\code{param.lowbnd}}{\link[base]{numeric} \link[base]{vector} holding the lower bounds of the
parameters.}

\item{\code{param.upbnd}}{\link[base]{numeric} \link[base]{vector} holding the upper bounds of the
parameters.}

\item{\code{orig.cop}}{linear-linear 2-dimensional '\code{\link[copula:Copula-class]{Copula}}'
object of the package '\pkg{copula}'.}

\item{\code{shift}}{\link[base]{logical} value indicating whether the (u-periodic)
copula should be shifted by 0.5 in u direction.}
}}

\section{Objects from the Class}{

Objects are created by    \code{\link{cyl_rot_combine}()}.
}

\section{Extends}{

Class '\code{cyl_rot_combine}' extends class '\code{\link[copula:Copula-class]{Copula}}'.
}

\references{
\insertRef{Nelsen2006}{cylcop}

\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
