% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvpredRisk.R
\name{cvpredRisk}
\alias{cvpredRisk}
\title{Output the prediction risks of the cross-validation model averaging (CVMA) method for partial linear functional additive models (PLFAMs)}
\usage{
cvpredRisk(
  M,
  nump,
  numq,
  a2,
  a3,
  nfolds,
  X.train,
  ZZ.train,
  Y.train,
  X.pred,
  ZZ.pred,
  Y.pred,
  nbasis,
  tt
)
}
\arguments{
\item{M}{The number of candidate models.}

\item{nump}{The number of scalar predictors in candidate models.}

\item{numq}{The number of funtional principal components (FPCs) in candidate models.}

\item{a2}{The number of FPCs in each candidate model. See \code{\link{modelspec}}.}

\item{a3}{The index for each component in each candidate model. See \code{\link{modelspec}}.}

\item{nfolds}{The number of folds used in cross-validation.}

\item{X.train}{The training data of scalar predictors.}

\item{ZZ.train}{The training data of the functional predictor.}

\item{Y.train}{The training data of response variable.}

\item{X.pred}{The test data of scalar predictors.}

\item{ZZ.pred}{The test data of the functional predictor.}

\item{Y.pred}{The test data of response variable.}

\item{nbasis}{The number of basis functions used for spline approximation.}

\item{tt}{The vector of recording/measurement points for the functional predictor.}
}
\value{
A \code{list} of
    \item{cv}{Mean squared error risk in training data set, produced by CVMA method.}
    \item{ws}{A \code{vector} of weights estimator.}
    \item{predcv}{Mean squared prediction error risk in test data set, produced by CVMA method.}
}
\description{
Calculate the estimated weights for averaging across all candidate models and the corresponding
     mean squared prediction error risk.
}
