% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{varselect}
\alias{varselect}
\title{Automatically select explanatory variables for a curve type}
\usage{
varselect(
  x,
  y,
  type = "logistic",
  folds = 10,
  constant = c(TRUE, FALSE),
  sign = NULL,
  reps = 3,
  search = c("backward", "forward"),
  wsel = c("select", "combine"),
  dummy = NULL
)
}
\arguments{
\item{x}{A matrix of explanatory variables. Excess reserve must be the first input.Additional regressor follow (optional).}

\item{y}{A vector of normalised interest rates.}

\item{type}{The type of the reserve demand curve. This can be any of \code{logistic}, \code{redLogistic}, \code{fixLogistic}, \code{doubleExp}, \code{exponential}, \code{fixExponential}, \code{arctan}, \code{linear}. See details in \code{\link{curve}}}

\item{folds}{Folds to use for cross-validation.}

\item{constant}{A logical (\code{TRUE} or \code{FALSE}) whether to include a constant or not.}

\item{sign}{A vector of equal length to the number of additional regressors in \code{x} (excluding the constant (if used) and the excess reserves) of positive and negative values (any) that will be used to obtain signs to restrict the values of the estimated parameters. Use \code{NULL} for no restrictions.}

\item{reps}{Number of repetitions for the particle swarm optimisation.}

\item{search}{Search strategy for variable inclusion. With \code{forward} the model starts from no explanatory variables, and evaluates potential additions. With \code{backward} the model starts with all variables and evaluates for potential exclusions.}

\item{wsel}{Use the minimum error set of parameters (\code{select}) or the combination of the pool parameters using the heuristic in Kourentzes et al., (2019) (\code{combine}).}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}
}
\value{
Returns a list with the recommended variable selection choice:
\itemize{
 \item \code{keep} a logical vector with which variables to keep.
 \item \code{errors} statistics of the cross-validated MSE error.
}
}
\description{
Using cross-validation automatically select explanatory variables for a reserve
demand curve type.
}
\examples{
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1:3,drop=FALSE]
  varKeep <- varselect(x,rate,folds=5)
  # Print result
  print(varKeep)
  # Fit curve with the selected variables
  curve(x[,varKeep$keep,drop=FALSE],rate)
}

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{curve}}, and \code{\link{cvfit}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
