% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{pMAD_BM_c}
\alias{pMAD_BM_c}
\title{CDF of the distribution of the maximum absolute deviation of Brownian motion in [0,1] interval, conditional on its terminal value}
\usage{
pMAD_BM_c(
  q,
  w1,
  method = 1,
  exp_tolerance = -30,
  summands = ceiling(q * sqrt(72) + 3/2)
)
}
\arguments{
\item{q}{the quantity at which CDF will be evaluated. Currently accepts only a scalar}

\item{w1}{the terminal value}

\item{method}{different infinite series to use (1,2,3)}

\item{exp_tolerance}{numerical tolerance as the stopping rule when evaluating the infinite sum (default -30 on the exponential scale)}

\item{summands}{number of terms to evaluate (default is ceiling(q * sqrt(72) + 3/2))}
}
\value{
a scalar value
}
\description{
CDF of the distribution of the maximum absolute deviation of Brownian motion in [0,1] interval, conditional on its terminal value
}
