% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemicals_in_list}
\alias{get_chemicals_in_list}
\title{Get chemicals in a given chemical list}
\usage{
get_chemicals_in_list(
  list_name = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{list_name}{The name of the list of chemicals}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of the chemical list
}
\description{
Get chemicals in a given chemical list
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Retrieve chemicals contained in chemical list 'CCL4'
ccl4_chemicals <- get_chemicals_in_list(list_name = 'CCL4')
\dontshow{\}) # examplesIf}
}
