% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_fate_by_dtxsid_batch}
\alias{get_fate_by_dtxsid_batch}
\title{Retrieve chemical fate data in batch search}
\usage{
get_fate_by_dtxsid_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A vector of chemicals identifier DTXSIDs}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.table containing chemical fate information for the chemicals
with DTXSID matching the input parameter.
}
\description{
Retrieve chemical fate data in batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemical fate by dtxsids
chemical_fates <- get_fate_by_dtxsid_batch(DTXSID = c('DTXSID7020182',
                                                      'DTXSID2021315'))
\dontshow{\}) # examplesIf}
}
