% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norway_county.R
\docType{data}
\name{nor_county_map_bxxxx_insert_oslo_dt}
\alias{nor_county_map_bxxxx_insert_oslo_dt}
\alias{nor_county_map_b2024_insert_oslo_dt}
\alias{nor_county_map_b2020_insert_oslo_dt}
\alias{nor_county_map_b2019_insert_oslo_dt}
\alias{nor_county_map_b2017_insert_oslo_dt}
\alias{nor_county_position_geolabels_b2024_insert_oslo_dt}
\alias{nor_county_position_geolabels_b2020_insert_oslo_dt}
\alias{nor_county_position_geolabels_b2019_insert_oslo_dt}
\alias{nor_county_position_geolabels_b2017_insert_oslo_dt}
\title{Maps of Norwegian counties with an insert for Oslo in data.table format}
\format{
\describe{
\item{long}{Location code.}
\item{lat}{Location name.}
\item{order}{The order that this line should be plotted in.}
\item{group}{Needs to be used as 'group' aesthetic in ggplot2.}
\item{location_code}{Location code (county code).}
}

An object of class \code{data.table} (inherits from \code{data.frame}) with 4537 rows and 5 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 4780 rows and 5 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 4589 rows and 5 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 15 rows and 4 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 11 rows and 4 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 18 rows and 4 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 19 rows and 4 columns.
}
\usage{
nor_county_map_b2024_insert_oslo_dt

nor_county_map_b2020_insert_oslo_dt

nor_county_map_b2019_insert_oslo_dt

nor_county_map_b2017_insert_oslo_dt

nor_county_position_geolabels_b2024_insert_oslo_dt

nor_county_position_geolabels_b2020_insert_oslo_dt

nor_county_position_geolabels_b2019_insert_oslo_dt

nor_county_position_geolabels_b2017_insert_oslo_dt
}
\description{
We conveniently package map datasets for Norwegian counties
(taken from Geonorge) that can be used in ggplot2 without needing any geo
libraries. This data is licensed under Creative Commons BY 4.0 (CC BY 4.0).
}
\details{
Borders for 2024, 2020, 2019, and 2017 are provided.
}
\examples{
# 2024 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_county_map_b2024_insert_oslo_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  linewidth = 0.4
)
q <- q + annotate(
  "text",
  x = csmaps::nor_xxx_position_title_insert_oslo_b2024_insert_oslo_dt$long,
  y = csmaps::nor_xxx_position_title_insert_oslo_b2024_insert_oslo_dt$lat,
  label = "Oslo"
)
q <- q + theme_void()
q <- q + coord_quickmap()
q


# 2020 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_county_map_b2020_insert_oslo_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  linewidth = 0.4
)
q <- q + annotate(
  "text",
  x = csmaps::nor_xxx_position_title_insert_oslo_b2020_insert_oslo_dt$long,
  y = csmaps::nor_xxx_position_title_insert_oslo_b2020_insert_oslo_dt$lat,
  label = "Oslo"
)
q <- q + theme_void()
q <- q + coord_quickmap()
q

# 2019 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_county_map_b2019_insert_oslo_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  linewidth = 0.4
)
q <- q + annotate(
  "text",
  x = csmaps::nor_xxx_position_title_insert_oslo_b2019_insert_oslo_dt$long,
  y = csmaps::nor_xxx_position_title_insert_oslo_b2019_insert_oslo_dt$lat,
  label = "Oslo"
)
q <- q + theme_void()
q <- q + coord_quickmap()
q

# 2017 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_county_map_b2017_insert_oslo_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  linewidth = 0.4
)
q <- q + annotate(
  "text",
  x = csmaps::nor_xxx_position_title_insert_oslo_b2017_insert_oslo_dt$long,
  y = csmaps::nor_xxx_position_title_insert_oslo_b2017_insert_oslo_dt$lat,
  label = "Oslo"
)
q <- q + theme_void()
q <- q + coord_quickmap()
q
}
\keyword{datasets}
