% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractResults.R
\name{getCoreRS}
\alias{getCoreRS}
\title{Get core rules from phase 3 tpl and til}
\usage{
getCoreRS(D, rm, tpl, til, cov.thresh, perf.thresh)
}
\arguments{
\item{D}{input matrix D}

\item{rm}{binary rule matrix}

\item{tpl}{list of top performances}

\item{til}{list of top rule set index matrices}

\item{cov.thresh}{core coverage threshold, defaults is 95}

\item{perf.thresh}{core performance threshold, default is 90}
}
\description{
Get core rules from phase 3 tpl and til
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
til.p2 <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,pool.sizes=c(60,20,20),
          max.stored=100,shouldPrint = FALSE)
tpl.p2 <- evaluateListOfIMs(D,Q,rm.full,til.p2)
core.rs <- getCoreRS(D,rm.full,tpl.p2,til.p2) # core.rs should be r1, r2, r3
}
