% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossrunem.r
\name{crossrunemcont}
\alias{crossrunemcont}
\title{Continuation of an existing sequence of joint probabilities for
crossings and longest run, based on the empirical median.}
\usage{
crossrunemcont(emstart, n1 = 61, nmax = 100, prec = 120, printn = FALSE)
}
\arguments{
\item{emstart}{existing sequence}

\item{n1}{sequence length for the first new case addedc}

\item{nmax}{max sequence length.}

\item{prec}{mpft precision.}

\item{printn}{logical for including progress output.}
}
\value{
nfi, number of sequences with m successes, starting with a success, and
nfn, number of sequences with m successes, not starting with a success.
}
\description{
Continuation of an existing sequence of the number of
crossings C and the longest run L in a sequence of n independent
continuous observations classified as above or below the empirical
median. To enhance precision, results are stored in mpfr arrays and
the probabilities are multiplied by \eqn{choose(n,m)/2} where m=n/2,
even n assumed. The probabilities are integers in this representation.
}
