% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossrunauto.r
\name{crossrunauto}
\alias{crossrunauto}
\title{Joint Distribution for Crossings and Runs, autocorrelated Sequence}
\usage{
crossrunauto(
  nmax = 100,
  prob = 0.5,
  changeprob = 0.5,
  mult = 2,
  prec = 120,
  printn = FALSE
)
}
\arguments{
\item{nmax}{max sequence length.}

\item{prob}{success probability p.}

\item{changeprob}{unrestricted change probability. If \eqn{p \geq 0.5},
probability of changing to success, if not probability of changing to
failure.}

\item{mult}{multiplier for joint probabilities.}

\item{prec}{mpft precision.}

\item{printn}{logical for progress output.}
}
\value{
list of joint probabilities.
}
\description{
Joint probability distribution for the number of crossings
C and the longest run L in a sequence of n  autocorrelated Bernoulli
observations with success probability p. To enhance precision, results
are stored in mpfr arrays and the probabilities are multiplied by
\eqn{m^{n-1}} for a multiplier m.
}
\examples{
# p=0.6, independence
cr10.6 <- crossrunbin(nmax=10, prob=0.6, printn=TRUE)
cra10.6 <- crossrunauto(nmax=10, prob=0.6, changeprob=.6, printn=TRUE)
Rmpfr::asNumeric(cr10.6$pt[[10]])
Rmpfr::asNumeric(cr10.6$pt[[10]])
Rmpfr::asNumeric(cr10.6$pt[[10]]) - Rmpfr::asNumeric(cra10.6$pt[[10]]) # equal


# p=0.6, some dependence
cr10.6 <- crossrunbin(nmax=10, prob=0.6, printn=TRUE)
cra10.6.u.5 <- crossrunauto(nmax=10, prob=0.6, changeprob=.5, printn=TRUE)
round(Rmpfr::asNumeric(cr10.6$pt[[10]]),1)
round(Rmpfr::asNumeric(cra10.6.u.5$pt[[10]]),1) # not the same
}
