% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.crossnma.R
\name{print.summary.crossnma}
\alias{print.summary.crossnma}
\title{Print summary of cross-design & -format network meta-analysis or
regression}
\usage{
\method{print}{summary.crossnma}(x, digits = gs("digits"), ...)
}
\arguments{
\item{x}{An object of class \code{crossnma}.}

\item{digits}{The number of significant digits printed. The default
value is 3.}

\item{\dots}{Additional arguments.}
}
\value{
No return value (print function).
}
\description{
Print results of cross-design and cross-format network
meta-analysis or meta-regression. In addition, the call used to
create the JAGS model is printed.
}
\examples{
\dontrun{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
stddata # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
set.seed(1909)
fit <- crossnma(mod)

# Display the output (with 5 digits)
print(summary(fit), digits = 5)
}

}
\seealso{
\code{\link{summary.crossnma}}
}
\author{
Tasnim Hamza \email{hamza.a.tasnim@gmail.com}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
