% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clpm_gamm4_c.R
\name{clpm_gamm4_c}
\alias{clpm_gamm4_c}
\title{Title Cross-lag analysis based on generalized additive mixture models}
\usage{
clpm_gamm4_c(xname, yname, data.x1, data.y1, data.xt, data.yt, z)
}
\arguments{
\item{xname}{If cross lagged analysis is used between x and y, 'xname' is the name of x}

\item{yname}{If cross lagged analysis is used between x and y, 'yname' is the name of y}

\item{data.x1}{A numeric variable.}

\item{data.y1}{A numeric variable. 'data.x1' and 'data.y1' comes from the first time point}

\item{data.xt}{A numeric variable.}

\item{data.yt}{A numeric variable. 'data.xt' and 'data.yt' comes from the another time point
'data.x1', 'data.y1','data.xt' and 'data.yt' can be the data processed by the function 'adjust_target()'}

\item{z}{In the generalized additive mixture model, a random intercept is specified and the random effects are grouped by z.
'z' and 'data.x1', 'data.y1','data.xt','data.yt' are all numeric variables that should ideally correspond to each other.}
}
\value{
A dataframe containing the result of generalized additive mixture model (consists of a smoothing term, a linear term and a stochastic intercept).
}
\description{
Title Cross-lag analysis based on generalized additive mixture models
}
\examples{
data(test_data1)
data(test_data2)
result <- clpm_gamm4_c("ASI","PWRI",test_data1$ASI,test_data1$PWRI,
                     data.xt = test_data2$ASI,data.yt = test_data2$PWRI,z=test_data1$time)
}
