% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_space.R
\name{choose_a}
\alias{choose_a}
\title{Suggests unit cell side, a, based on atom content}
\usage{
choose_a(Z, D, SG = "P1", k = ksigma, Ma = 5)
}
\arguments{
\item{Z}{A vector of atom Z numbers.}

\item{D}{A real number. The distance between the two furthest atoms
in the cell.}

\item{SG}{2-letters character string. Symmetry. There are only two
symmetries possible when working within 1D crystallography, P1 (no
symmetry)and P-1 (inversion through the origin). SG can be either "P1"
or "P-1" for this function.}

\item{k}{A real number. It controls the standard deviation of the 
gaussian function describing the atom and, thus, the shape of the
associated peak. The standard deviation sigma is given by:
         \code{sigma = k * sqrt(Z)}}

\item{Ma}{A real number. Each gaussian atom has tails truncated at a
distance of Ma * sigma from its peak.}
}
\value{
A real number that suggests a feasible unit cell side 
containing all atoms.
}
\description{
The unit cell side is roughly calculated by adding two times the half-width
of the widest gaussian atom to the largest inter-atomic distance. The
half-width of the largest gaussian is computed as Ma times the gaussian
sigma. If the "P-1" symmetry is present, D is doubled.
}
\examples{
# 2 carbon atoms, a sulphur and an oxygen
Z <- c(6,8,16,6)

# Distance between the two carbons is 15 angstroms
D <- 15
a <- choose_a(Z,D)
}
