% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process_tools.R
\name{loop_function}
\alias{loop_function}
\title{Loop Function.
#' \code{loop_function} is an iterator to loop through}
\usage{
loop_function(
  func = NULL,
  args = list(data = NULL),
  x_list = NULL,
  bind = "rbind",
  parallel = TRUE,
  as_list = FALSE
)
}
\arguments{
\item{func}{A function.}

\item{args}{A list of argauments required by function.}

\item{x_list}{Names of objects to loop through.}

\item{bind}{Complie results, "rbind" & "cbind" are available.}

\item{parallel}{Logical, parallel computing.}

\item{as_list}{Logical, whether outputs  to be a list.}
}
\value{
A data.frame or list
}
\description{
Loop Function.
#' \code{loop_function} is an iterator to loop through
}
\examples{
dat = UCICreditCard[24:26]
num_x_list = get_names(dat = dat, types = c('numeric', 'integer', 'double'),
                      ex_cols = NULL, get_ex = FALSE)
dat[ ,num_x_list] = loop_function(func = outliers_kmeans_lof, x_list = num_x_list,
                                   args = list(dat = dat),
                                   bind = "cbind", as_list = FALSE,
                                 parallel = FALSE)
}
