% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{partial_dependence_plot}
\alias{partial_dependence_plot}
\alias{get_partial_dependence_plots}
\title{partial_dependence_plot}
\usage{
partial_dependence_plot(model, x, x_train, n.trees = NULL)

get_partial_dependence_plots(
  model,
  x_train,
  x_list,
  n.trees = NULL,
  dir_path = getwd(),
  save_data = TRUE,
  plot_show = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{model}{A data frame of training with predicted prob or score.}

\item{x}{The name of an independent variable.}

\item{x_train}{A data.frame with independent variables.}

\item{n.trees}{Number of trees for best.iter of gbm.}

\item{x_list}{Names of independent variables.}

\item{dir_path}{The path for periodically saved graphic files.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{plot_show}{Logical, show model performance in current graphic device. Default is FALSE.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}
}
\description{
\code{partial_dependence_plot} is for generating a partial dependence plot.
\code{get_partial_dependence_plots} is for ploting partial dependence of all vairables in x_list.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1))

train_test = train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))
#plot partial dependency of one variable
partial_dependence_plot(model = lr_model, x ="LIMIT_BAL", x_train = dat_train)
#plot partial dependency of all variables
pd_list = get_partial_dependence_plots(model = lr_model, x_list = x_list[1:2],
 x_train = dat_train, save_data = FALSE,plot_show = TRUE)
}
