% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{permutation_test_impl}
\alias{permutation_test_impl}
\title{Generates realisations of the permutational test statistic distribution}
\usage{
permutation_test_impl(
  resids,
  tr_mat,
  xb,
  invS,
  family2,
  Z,
  weight,
  iter = 1000L,
  verbose = TRUE
)
}
\arguments{
\item{resids}{A numeric vector of generalised residuals}

\item{tr_mat}{A matrix. Each column is a new random treatment allocation with 1s (treatment group) and 0s (control group)}

\item{xb}{A numeric vector of fitted linear predictors}

\item{invS}{A matrix. If using the weighted statistic then it should be the inverse covariance matrix of the observations}

\item{family2}{A string naming the link function}

\item{Z}{A matrix with columns indicating cluster membership}

\item{weight}{Logical value indicating whether to use the weighted statistic (TRUE) or the unweighted statistic (FALSE)}

\item{iter}{Integer. Number of permutation test iterations.}

\item{verbose}{Logical indicating whether to report detailed output}
}
\value{
A numeric vector of quasi-score test statistics for each of the permutations
}
\description{
Generates realisations of the permutational test statistic distribution from a given matrix of permutations
}
