% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps_read.R
\name{cps_read}
\alias{cps_read}
\title{Read in CPS data}
\usage{
cps_read(
  years = seq(1994, 2018, 2),
  dir = "cps_data",
  cols = cpsvote::cps_cols,
  names_col = "new_name",
  join_dfs = TRUE
)
}
\arguments{
\item{years}{Which years to read in. Thie function will read data from files
in \code{dir} whose names contain these 4-digit years.}

\item{dir}{The folder where the CPS data files live. These files should
follow a naming scheme that contains the 4-digit year of the results in
question, and have a ".zip" or ".gz" extension.}

\item{cols}{Which columns to read. This must be a data frame, with required
columns \code{start_pos},\code{end_pos}, and \code{year}. The default value is \code{cps_cols},
which reads from the list \code{cpsvote::cps_cols}. See \code{vignette("add-variables")}
for details about how to specify a different set of \code{cols}.}

\item{names_col}{The column in \code{cols} that contains column names for the
specified columns. If none exists, use \code{names_col = NULL}}

\item{join_dfs}{Whether to combine all of the years into a single data frame,
or leave them as a list of data frames. Defaults to \code{TRUE} with a warning.}
}
\value{
a data frame, or list of data frames
}
\description{
Load multiple years of data from the Current Population Survey.
This function will also download the data for you, if it is not present in
the given \code{dir}.
}
\examples{
\dontrun{cps_read(years = 2016, names_col = "new_name")}

}
