% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_rcpp.R
\name{run_model_single}
\alias{run_model_single}
\title{Running a singly constrained model}
\usage{
run_model_single(flows, distance, weight = NULL, beta = 0.25)
}
\arguments{
\item{flows}{A vector of either origin (production constrained) or destination (attraction constrained) flows.}

\item{distance}{a distance matrix between origins and destinations, provide distance in km.}

\item{weight}{a vector of weights for the unconstrained part of the model.}

\item{beta}{Exponent to use when calculating the cost function, default .25.}
}
\value{
A list containing a matrix with predicted values.
}
\description{
This function is the C++ implementation of run_model, it will run a singly constrained model
there must be a match in the dimensions, when running a production constrained model,
any(dim(distance) == length(flows)) must be TRUE
if no values for weight are provided, a vector with ones is used
}
\examples{

data(flows_test)
data(distance_test)

flows_test <- apply(flows_test,MARGIN = 1,FUN = sum)

model_test <- run_model_single(flows_test,distance_test)

}
