% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{sample_lm_hs}
\alias{sample_lm_hs}
\title{Sample linear regression parameters assuming horseshoe prior}
\usage{
sample_lm_hs(y, X, params, XtX = NULL, X_test = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X}{\code{n x p} matrix of predictors}

\item{params}{the named list of parameters containing
\enumerate{
\item \code{mu} \code{n x 1} vector of conditional means (fitted values)
\item \code{sigma} the conditional standard deviation
\item \code{coefficients} a named list of parameters that determine \code{mu}
}}

\item{XtX}{the \code{p x p} matrix of \code{crossprod(X)} (one-time cost);
if NULL, compute within the function}

\item{X_test}{matrix of predictors at test points (default is NULL)}
}
\value{
The updated named list \code{params} with draws from the full conditional distributions
of \code{sigma} and \code{coefficients} (along with updated \code{mu} and \code{mu_test} if applicable).
}
\description{
Sample the parameters for a linear regression model assuming a
horseshoe prior for the (non-intercept) coefficients. The number of predictors
\code{p} may exceed the number of observations \code{n}.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta} the \code{p x 1} vector of regression coefficients
\item \code{sigma_beta} \code{p x 1} vector of regression coefficient standard deviations
(local scale parameters)
\item \code{xi_sigma_beta} \code{p x 1} vector of parameter-expansion variables for \code{sigma_beta}
\item \code{lambda_beta} the global scale parameter
\item \code{xi_lambda_beta} parameter-expansion variable for \code{lambda_beta}
components of \code{beta}
}
}
\keyword{internal}
