% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature.R
\docType{data}
\name{signature}
\alias{signature}
\title{Mutational signatures data from COSMIC, Catalogue Of Somatic Mutations In
Cancer (v3.3 - June 2022)}
\format{
A list with the following elements:
\itemize{
\item GRCh37: Homo sapiens (human) genome assembly GRCh37.
\item GRCh38: Homo sapiens (human) genome assembly GRCh38.
\item mm9: Mus musculus (house mouse) genome assembly mm9.
\item mm10: Mus musculus (house mouse) genome assembly mm10.
\item rn6: Rattus norvegicus (Norway rat) genome assembly rn6.
}

Each element contains the sub elements:
\itemize{
\item SBS96: Strand-agnostic single-base substitutions in trinucleotide context.
\item DBS78: Strand-agnostic doublet-base substitutions.
}

Element GRCh37 contains the additional sub elements:
\itemize{
\item ID: Strand-agnostic indels (short insertions and deletions).
}
}
\source{
\url{https://cancer.sanger.ac.uk/signatures/}.
}
\usage{
signature
}
\description{
Mutational signatures data from COSMIC, Catalogue Of Somatic Mutations In
Cancer (v3.3 - June 2022)
}
\section{Remark}{

The signatures are all genome signatures. \cr See \link[ICAMS]{CatalogRowOrder}
in package ICAMS for the classification of mutation types.
}

\examples{
sbs96_sig <- signature$GRCh37$SBS96

}
\keyword{datasets}
