# Generated by LaTeX DogWagger Version 4.0.5 from file <NCTLL_904.tex>
# Date: [2020-9-17 13:16:5] 
# Do NOT edit this file. Edit the LaTeX source!!

# - <Section 2> - 
#' Plot total cases over time for a selected country. 
#'
#' Defaults to Italy, as this was our demonstration. 
#'     Add a linear regression by specifying smooth=TRUE. 
#' @param country Text name of country (in owid frame)
#' @param pdf TRUE will print value
#' @param daystart first day
#' @param dayend last day to plot
#' @param log TRUE will take base 10 logarithm of y-axis values
#' @param smooth TRUE will try to fit linear model (use with logarithm)
#' @param prefix defaults to ''; a text value will be prefixed to PDF name *after* country_ name. 
#' @keywords corona total cases country 
#' @export 
#' @import ggplot2 
#' @importFrom stats lm
#' @importFrom graphics frame 
#' @examples
#' corona_totals( country='Italy', daystart=60, dayend=76, log=TRUE, smooth=TRUE ) 
#' corona_totals(country='United Kingdom', log=TRUE, smooth=TRUE)

corona_totals <- function (country='Italy', daystart=60, dayend=76, pdf=FALSE, 
    log=FALSE, smooth=FALSE, prefix='')
{ cc <- country_code(country, owid); 
  Cntry <- owid[ owid$iso_code==cc, ];
  DAYS <- daystart:dayend; 
  THISCNTRY <- data.frame(Cntry[DAYS,], row.names=seq_along(DAYS));
if(nrow(THISCNTRY) < 10)
  { stop( paste('Too few rows < 10, country=', country, 'days=', daystart, ':', dayend) );
  }; 
  mymain <- paste('COVID-19 in ', country);
  islog = ''; 
  ylabel = 'Cases'; 
if(log)
  { islog = '_log'; 
    ylabel = 'log(Cases)'; 
    THISCNTRY$total_cases <- log(THISCNTRY$total_cases, base=10); 
  }; 
  PdfFilename <- paste(country, prefix, islog, '_total_cases.pdf', sep=''); 
  corona_pdf(PdfFilename, 5, 5, pdf); 
  myplot <- ggplot(THISCNTRY, aes(x=date, y=.data$total_cases)) + geom_point() + geom_line() + 
    labs(title=mymain, x='Date', y=ylabel);  
if(smooth)
  { myplot <- myplot + geom_smooth(method='lm', colour='red', linetype='solid'); 
  }; 
  corona_print(myplot); 
  corona_pdf_off(PdfFilename, pdf); 
}
# -END OF FILE- 
