% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifier_functions.R
\name{composite_id}
\alias{composite_id}
\alias{sequential_id}
\alias{random_id}
\title{Create unique identifier columns}
\usage{
composite_id(..., sep = "-")

sequential_id(width)

random_id()
}
\arguments{
\item{...}{Zero or more variable names from the tibble being
mutated (unquoted), and/or zero or more \verb{_id} functions, separated by
commas.}

\item{sep}{Character used to separate field values. Defaults to \code{"-"}}

\item{width}{(Integer) how many characters should the resulting string be?
Defaults to one plus the order of magnitude of the largest number.}
}
\value{
An amended \code{tibble} containing a column with identifiers in the
requested format.
}
\description{
A unique identifier is a pattern of words, letters and/or numbers that is
unique to a single record within a dataset.
Unique identifiers are useful because they identify individual observations,
and make it possible to change, amend or delete observations over time. They
also prevent accidental deletion when when more than one record contains the
same information(and would otherwise be considered a duplicate).

The identifier functions in corella make it easier to
generate columns with unique identifiers in a dataset. These functions can
be used within \code{\link[=set_events]{set_events()}}, \code{\link[=set_occurrences]{set_occurrences()}}, or (equivalently)
\code{\link[dplyr:mutate]{dplyr::mutate()}}.
}
\details{
Generally speaking, it is better to use existing
information from a dataset to generate identifiers. For this reason we
recommend using \code{composite_id()} to aggregate existing fields, if no
such composite is already present within the dataset. Composite IDs are
more meaningful and stable; they are easier to check and harder to overwrite.

It is possible to call
\code{sequential_id()} or \code{random_id()} within
\code{composite_id()} to combine existing and new columns.
}
\examples{
df <- tibble::tibble(
  eventDate = paste0(rep(c(2020:2024), 3), "-01-01"),
  basisOfRecord = "humanObservation",
  site = rep(c("A01", "A02", "A03"), each = 5)
  )

# Add composite ID using a random ID, site name and eventDate
df |>
  set_occurrences(
    occurrenceID = composite_id(random_id(),
                                site,
                                eventDate)
    )

# Add composite ID using a sequential number, site name and eventDate
df |>
  set_occurrences(
    occurrenceID = composite_id(sequential_id(),
                                site,
                                eventDate)
    )
}
