% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcops.R
\name{pcops}
\alias{pcops}
\title{Profile COPS Function (aka COPS Variant 2)}
\usage{
pcops(
  dis,
  loss = c("stress", "smacofSym", "smacofSphere", "strain", "sammon", "rstress",
    "powermds", "sstress", "elastic", "powersammon", "powerelastic", "powerstress",
    "sammon2", "powerstrain", "apstress", "rpowerstress"),
  type = "ratio",
  weightmat = NULL,
  ndim = 2,
  init = NULL,
  theta = c(1, 1, 1),
  stressweight = 1,
  cordweight,
  q = 2,
  minpts = ndim + 1,
  epsilon = 100,
  rang,
  optimmethod = c("ALJ", "pso", "SANN", "direct", "directL", "stogo", "MADS", "hjk"),
  lower = 0.5,
  upper = 5,
  verbose = 0,
  scale = c("proc", "sd", "none", "std"),
  normed = TRUE,
  s = 4,
  acc = 1e-05,
  itmaxo = 200,
  itmaxi = 5000,
  ...
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{loss}{which loss function to be used for fitting, defaults to strain. See Details.}

\item{type}{MDS type which may be one of "ratio", interval", "ordinal". Defaults to "ratio". Note not all loss arguments support all types; if not there will be an error and infor which types are supported. In that case choose another type.}

\item{weightmat}{(optional) a matrix of nonnegative weights; defaults to 1 for all off diagonals}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration. If not supplied, the Torgerson scaling result of the dissimilarity matrix dis^theta[2]/enorm(dis^theta[2],weightmat) is used.}

\item{theta}{the theta vector of free parameters; see details for the number of free parameters for each loss function. Defaults to 1 for all free parameters. Make sure to supply a theta of the correct length as the mechanisms in place to automatically choose theta/upper/lower are dependent on the optimizer and ad hoc: If this is a vector with more elements than necessary, it is either cut (so for a vector of length 3 and a function with 2 free parameters, the first two elements of the vector are used) or there will be an error. If a scalar is given as argument and the number of free parameters is larger than 1, the scalar will be recycled and this may also make the optimizers equate all free parameters.}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{cordweight}{weight to be used for the cordillera; if missing gets estimated from the initial configuration so that copstress = 0 for theta=1}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to ndim+1}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{rang}{range of the minimum reachabilities to be considered. If missing it is found from the initial configuration by taking 1.5 times the maximal minimum reachability of the model with theta=1. If NULL it will be normed to each configuration's minimum and maximum distance, so an absolute value of goodness-of-clusteredness. Note that the latter is not necessarily desirable when comparing configurations for their relative clusteredness. See also \code{\link[cordillera]{cordillera}}.}

\item{optimmethod}{What general purpose optimizer to use? Defaults to our adaptive LJ version (ALJ). Also allows particle swarm optimization with s particles ("pso", \code{\link[pso]{psoptim}}) and simulated annealing ("SANN", \code{\link[stats]{optim}}), "directT" or "directL" (see \code{\link[nloptr]{direct}}), Hooke-Jeeves ("hjk", \code{\link[dfoptim]{hjk}}), StoGo ("stogo", \code{\link[nloptr]{stogo}}), and "snomadr" (\code{\link[crs]{snomadr}}). We recommend not using SANN and pso with the rstress, sstress and the power stress models. We made good experiences with ALJ, stogo, direct and directL and also snomadr.}

\item{lower}{A vector of the lower box contraints of the search region. Its length must match the length of theta.}

\item{upper}{A vector of the upper box contraints of the search region. Its length must match the length of theta.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose. Note that for models with some parameters fixed, the iteration progress of the optimizer shows different values also for the fixed parameters because due to the modular setup we always optimize over a three parameter vector. These values are inconsequential however as internally they will be fixed.}

\item{scale}{should the configuration be scaled and/or centered for calculating the cordillera? "std" standardizes each column of the configurations to mean=0 and sd=1 (typically not a good idea), "sd" scales the configuration by the maximum standard devation of any column (default), "proc" adjusts the fitted configuration to the init configuration (or the Togerson scaling solution if init=NULL). This parameter only has an effect for calculating the cordillera, the fitted and returned configuration is NOT scaled.}

\item{normed}{should the cordillera be normed; defaults to TRUE}

\item{s}{number of particles if pso is used}

\item{acc}{termination threshold difference of two successive outer minimization steps.}

\item{itmaxo}{iterations of the outer step (optimization over the hyperparmeters; if solver allows it). Defaults to 200.}

\item{itmaxi}{iterations of the inner step (optimization of the MDS). Defaults to 5000.}

\item{...}{additional arguments to be passed to the optimization procedure}
}
\value{
A list with the components
        \itemize{
        \item copstress: the weighted loss value
        \item OC: the OPTICS cordillera for the scaled configuration (as defined by scale) 
        \item optim: the object returned from the optimization procedure
        \item stress: the stress (square root of stress.m)
        \item stress.m: default normalized stress 
        \item parameters: the parameters used for fitting (kappa, lambda)
        \item fit: the returned object of the fitting procedure
        \item cordillera: the cordillera object
}
}
\description{
Metaparameter selection for MDS models baseed on the Profile COPS approach (COPS Variant 2). It uses copstress for hyperparameter selection of explicit transformations (currently power transformations). It is a special case of a STOPS model and predated it; \code{\link[stops]{stops}} has more functionality and can be seen as the successor. pcops uses explicitly normalized stress for copstress (not stress-1).
}
\details{
Currently allows for the following models:
\itemize{
\item Power transformations applied to observed proximities only (theta, upper, lower should be numeric scalar): Strain loss/Torgerson scaling (\code{strain}, workhorse: smacofx::cmdscale), Stress for symmetric matrices (\code{smacofSym}, \code{stress},\code{smacofSphere} for scaling onto a sphere; workhorse: smacof::smacofSym), Sammon mapping (\code{sammon}, workhorse is smacofx::sammon or \code{sammon2}, workhorse: smacof::smacofSym), elastic scaling (\code{elastic}, workhorse smacof::smacofSym), Alscal or S-Stress \code{sstress} (workhorse: smacofx::powerStressMin)
\item Power transformations of fitted distances only (theta, upper, lower should be numeric scalar): r-stress \code{rstress} (workhorse: smacofx:rStressMin)
\item Power transformations applied to fitted distances and observed proximities (theta, upper, lower should be numeric of length 2): Power MDS (\code{powermds}, workhorse: smacofx::powerStressMin), Sammon Mapping/elastic scaling with powers (\code{powersammon}, \code{powerelastic}, workhorse: smacofx::powerStressMin)
\item Power transformations applied to fitted distances, observed proximities and weights (theta, upper, lower should be numeric of length 3): power stress (POST-MDS, \code{powerstress}, workhorse: smacofx::powerStressMin), restricted power stress with equal transformations for distances and proximities (\code{rpowerstress}); workhorse: smacofx::powerStressMin), approximated power stress (\code{apstress}; workhorse: smacof::smacofSym)
}
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
set.seed(210485)
#configuration is scaled with highest column sd for calculating cordilera 
res1<-pcops(dis,loss="strain",lower=0.1,upper=5,minpts=2) 
res1
summary(res1)
plot(res1)


}
\keyword{clustering}
\keyword{multivariate}
