% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaylorContour.R
\name{TaylorContour}
\alias{TaylorContour}
\title{Computes tail probabilities of a Gaussian field on a contour with Taylor's 
method.}
\usage{
TaylorContour(x, y, cont, R)
}
\arguments{
\item{x}{x-Coordinates of the grid on which the data is observed.}

\item{y}{y-Coordinates of the grid on which the data is observed.}

\item{cont}{The contour of f at value level}

\item{R}{An array of dimension c(length(x),length(y),n) containing the 
realizations of the field.}
}
\value{
A function g that computes for u>0 the probility that the supremum of
        the field exceeds u.
}
\description{
Computes tail probabilities of a Gaussian field on a contour with Taylor's 
method.
}

