% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{BETA}
\alias{BETA}
\alias{new_BETA}
\alias{new_BETA_lci}
\alias{new_BETA_lci2}
\title{Factory for a BETA distribution object}
\usage{
new_BETA(p_shape1, p_shape2, p_dimnames = "rvar")

new_BETA_lci(p_mean, p_lci, p_uci, p_dimnames = "rvar")

new_BETA_lci2(p_mean, p_lci, p_uci, p_dimnames = "rvar")
}
\arguments{
\item{p_shape1}{non-negative parameters of the Beta distribution}

\item{p_shape2}{non-negative parameters of the Beta distribution}

\item{p_dimnames}{A character that represents the name of the dimension}

\item{p_mean}{A numeric that represents the expected value of the proportion}

\item{p_lci}{A numeric for the lower 95\% confidence interval}

\item{p_uci}{A numeric for the upper 95\% confidence interval}
}
\value{
An object of class \code{DISTRIBUTION}, \code{BETA}
}
\description{
Returns an BETA distribution object that produce random numbers
from a  beta distribution using the \code{\link{rbeta}} function
}
\section{Functions}{
\itemize{
\item \code{new_BETA_lci()}: Constructor based on confidence intervals. Preserve expected value.

\item \code{new_BETA_lci2()}: Constructor based on ML confidence intervals

}}
\note{
When using confidence intervals, the shape parameters are obtained
using the following formula:

\eqn{varp = (p_uci-p_lci)/4^2}

\eqn{shape1 = p_mean * (p_mean * (1 - p_mean) / varp - 1)}

\eqn{shape2 =(1 - p_mean) * (p_mean * (1 - p_mean) / varp - 1) }

new_BETA_lci2 estimate parameters using maximum likelihood
myDistr <- new_BETA_lci2(0.30,0.25,0.35)
myDistr$rfunc(10)
}
\examples{
myDistr <- new_BETA(1,1)
myDistr$rfunc(10)
myDistr <- new_BETA_lci(0.30,0.25,0.35)
myDistr$rfunc(10)
}
\author{
John J. Aponte
}
