% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont_did.R
\name{cont_did}
\alias{cont_did}
\title{Difference-in-differences with a Continuous Treatment}
\usage{
cont_did(
  yname,
  dname,
  gname = NULL,
  tname,
  idname,
  xformula = ~1,
  data,
  target_parameter = c("level", "slope"),
  aggregation = c("dose", "eventstudy", "none"),
  treatment_type = c("continuous", "discrete"),
  dose_est_method = c("parametric", "cck"),
  dvals = NULL,
  degree = 3,
  num_knots = 0,
  allow_unbalanced_panel = FALSE,
  control_group = c("notyettreated", "nevertreated", "eventuallytreated"),
  anticipation = 0,
  weightsname = NULL,
  alp = 0.05,
  bstrap = TRUE,
  cband = FALSE,
  boot_type = "multiplier",
  biters = 1000,
  clustervars = NULL,
  est_method = NULL,
  base_period = "varying",
  print_details = FALSE,
  cl = 1,
  ...
)
}
\arguments{
\item{yname}{The name of the outcome variable}

\item{dname}{The name of the treatment variable in the data.  The functionality of
\code{cont_did} is different from the \code{did} package in that the treatment variable is
the "amount" of the treatment in a particular period, rather than \code{gname} which
gives the time period when a unit becomes treated.  The \code{dname} variable should,
for a particular unit, be constant across time periods---even in pre-treatment periods.
For units that never participate in the treatment, the amount of the treatment may
not be defined in some applications---it is ignored in this function.}

\item{gname}{The name of the timing-group variable, i.e., when treatment starts for
a particular unit.  The value of this variable should be set to be 0 for units that
do not participate in the treatment in any time period.}

\item{tname}{The name of the column containing the time periods}

\item{idname}{The individual (cross-sectional unit) id name}

\item{xformula}{A formula for additional covariates.  This is not currently supported.}

\item{data}{The name of the data.frame that contains the data}

\item{target_parameter}{Two options are "level" and "slope".  In the first case, the function
will report level effects, i.e., ATT's.  In the second case, the function will report
slope effects, i.e., ACRT's}

\item{aggregation}{"dose" averages across timing-groups and time periods and provides results
as a function of the dose.  "eventstudy" averages across timing-groups and doses and reports
results as a function of the length of exposure to the treatment.

"none" is a stub for reporting fully disaggregated results that can be processed as desired
by the user.  This is not currently supported though.

The combination of the arguments \code{target_parameter} and \code{aggregation} strongly affects the
behavior of the function (and target of the analysis).  For example, setting
\code{target_parameter="level"} and \code{aggregation="eventstudy"} is effectively the same thing
as binarizing the treatment (i.e., where units are considered treated if they experience any
positive amount of the treatment) and reporting an event study.}

\item{treatment_type}{"continuous" or "discrete" depending on the nature of the treatment.
Default is "continuous".  "discrete" is not yet supported.}

\item{dose_est_method}{The method used to estimate the dose-specific effects.  The default
is "parametric", where the user needs to specify the number of knots and degree for
a B-spline which is assumed to be correctly specified.  The other option is "cck"
which uses the a data-driven nonparametric method to estimate the dose-specific effects
based on the \code{npiv} package and Chen, Christensen, and Kankanala (ReStud, 2025).}

\item{dvals}{The values of the treatment at which to compute dose-specific effects.
If it is not specified, the default choice will be use the percentiles of the dose among
all ever-treated units.}

\item{degree}{The degree of the B-Spline used in estimation.  The default is 3, which in
combination with the default choice for the \code{num-knots}, leads to fitting models for
the group of treated units that only that is a cubic polynomial in the dose.  Setting
\code{degree=1} will lead to a linear model, while setting \code{degree=2} will lead to a quadratic model.}

\item{num_knots}{The number of knots to include for the B-Spline.  The default is 0
so that the spline is global (i.e., this will amount to fitting a global polynomial).
There is a bias-variance tradeoff for including more or less knots.}

\item{allow_unbalanced_panel}{Whether or not function should
"balance" the panel with respect to time and id.  The default
values if \code{FALSE} which means that \code{\link[did:att_gt]{att_gt()}} will drop
all units where data is not observed in all periods.
The advantage of this is that the computations are faster
(sometimes substantially).}

\item{control_group}{Which units to use the control group.
The default is "nevertreated" which sets the control group
to be the group of units that never participate in the
treatment.  This group does not change across groups or
time periods.  The other option is to set
\code{group="notyettreated"}.  In this case, the control group
is set to the group of units that have not yet participated
in the treatment in that time period.  This includes all
never treated units, but it includes additional units that
eventually participate in the treatment, but have not
participated yet.}

\item{anticipation}{The number of time periods before participating
in the treatment where units can anticipate participating in the
treatment and therefore it can affect their untreated potential outcomes}

\item{weightsname}{The name of the column containing the sampling weights.
If not set, all observations have same weight.}

\item{alp}{the significance level, default is 0.05}

\item{bstrap}{Boolean for whether or not to compute standard errors using
the multiplier bootstrap.  If standard errors are clustered, then one
must set \code{bstrap=TRUE}. Default is \code{TRUE} (in addition, cband
is also by default \code{TRUE} indicating that uniform confidence bands
will be returned.  If bstrap is \code{FALSE}, then analytical
standard errors are reported.}

\item{cband}{Boolean for whether or not to compute a uniform confidence
band that covers all of the group-time average treatment effects
with fixed probability \code{1-alp}.  In order to compute uniform confidence
bands, \code{bstrap} must also be set to \code{TRUE}.  The default is
\code{TRUE}.}

\item{boot_type}{should be one of "multiplier" (the default) or "empirical".
The multiplier bootstrap is generally much faster, but \code{attgt_fun} needs
to provide an expression for the influence function (which could be challenging
to figure out).  If no influence function is provided, then the \code{pte}
package will use the empirical bootstrap no matter what the value of this
parameter.}

\item{biters}{The number of bootstrap iterations to use.  The default is 1000,
and this is only applicable if \code{bstrap=TRUE}.}

\item{clustervars}{A vector of variables names to cluster on.  At most, there
can be two variables (otherwise will throw an error) and one of these
must be the same as idname which allows for clustering at the individual
level. By default, we cluster at individual level (when \code{bstrap=TRUE}).}

\item{est_method}{the method to compute group-time average treatment effects.  The default is "dr" which uses the doubly robust
approach in the \code{DRDID} package.  Other built-in methods
include "ipw" for inverse probability weighting and "reg" for
first step regression estimators.  The user can also pass their
own function for estimating group time average treatment
effects.  This should be a function
\code{f(Y1,Y0,treat,covariates)} where \code{Y1} is an
\code{n} x \code{1} vector of outcomes in the post-treatment
outcomes, \code{Y0} is an \code{n} x \code{1} vector of
pre-treatment outcomes, \code{treat} is a vector indicating
whether or not an individual participates in the treatment,
and \code{covariates} is an \code{n} x \code{k} matrix of
covariates.  The function should return a list that includes
\code{ATT} (an estimated average treatment effect), and
\code{inf.func} (an \code{n} x \code{1} influence function).
The function can return other things as well, but these are
the only two that are required. \code{est_method} is only used
if covariates are included.}

\item{base_period}{Whether to use a "varying" base period or a
"universal" base period.  Either choice results in the same
post-treatment estimates of ATT(g,t)'s.  In pre-treatment
periods, using a varying base period amounts to computing a
pseudo-ATT in each treatment period by comparing the change
in outcomes for a particular group relative to its comparison
group in the pre-treatment periods (i.e., in pre-treatment
periods this setting computes changes from period t-1 to period
t, but repeatedly changes the value of t)

A universal base period fixes the base period to always be
(g-anticipation-1).  This does not compute
pseudo-ATT(g,t)'s in pre-treatment periods, but rather
reports average changes in outcomes from period t to
(g-anticipation-1) for a particular group relative to its comparison
group.  This is analogous to what is often reported in event
study regressions.

Using a varying base period results in an estimate of
ATT(g,t) being reported in the period immediately before
treatment.  Using a universal base period normalizes the
estimate in the period right before treatment (or earlier when
the user allows for anticipation) to be equal to 0, but one
extra estimate in an earlier period.}

\item{print_details}{Whether or not to show details/progress of computations.
Default is \code{FALSE}.}

\item{cl}{number of clusters to be used when bootstrapping; default is 1}

\item{...}{extra arguments that can be passed to create the correct subsets
of the data (depending on \code{subset_fun}), to estimate group time
average treatment effects (depending on \code{attgt_fun}), or to
aggregating treatment effects (particularly useful are \code{min_e},
\code{max_e}, and \code{balance_e} arguments to event study aggregations)}
}
\value{
cont_did_obj
}
\description{
A function for difference-in-differences with a continuous treatment in a
staggered treatment adoption setting.

\code{cont_did} currently supports staggered treatment with continuous treatments using
B-splines under the hood.
}
\examples{
# build small simulated data
set.seed(1234)
df <- simulate_contdid_data(
  n = 1000,
  num_time_periods = 4,
  num_groups = 4,
  dose_linear_effect = 0,
  dose_quadratic_effect = 0
)

# estimate effects of continuous treatment
cd_res <- cont_did(
  yname = "Y",
  tname = "time_period",
  idname = "id",
  dname = "D",
  data = df,
  gname = "G",
  target_parameter = "slope",
  aggregation = "dose",
  treatment_type = "continuous",
  control_group = "notyettreated",
  biters = 50,
  cband = TRUE,
  num_knots = 1,
  degree = 3,
)

summary(cd_res)

}
