% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add}
\alias{add}
\alias{ref_add}
\alias{add.Container}
\alias{ref_add.Container}
\alias{add.Dict}
\alias{ref_add.Dict}
\alias{add.dict.table}
\alias{ref_add.dict.table}
\title{Add Elements to Containers}
\usage{
add(.x, ...)

ref_add(.x, ...)

\method{add}{Container}(.x, ...)

\method{ref_add}{Container}(.x, ...)

\method{add}{Dict}(.x, ...)

\method{ref_add}{Dict}(.x, ...)

\method{add}{dict.table}(.x, ...)

\method{ref_add}{dict.table}(.x, ...)
}
\arguments{
\item{.x}{an \code{R} object of the respective class.}

\item{...}{elements to be added.}
}
\value{
For \link{Container}, an object of class \link{Container} (or one of the
respective derived classes).

For \link{dict.table} an object of class
\link{dict.table}.
}
\description{
Add elements to container-like objects.
}
\note{
While \link{add} uses copy semantics \link{ref_add} works by reference.

If \code{.x} is a \link{Container}, \link{Set} or \link{Deque} object, the elements being added
can (but must not) be named.

If \code{.x} is a \link{Dict} or \link{dict.table} object,
all elements \emph{must} be of the form \code{key = value}.
If one of the keys already exists, an error is given.
}
\examples{

co = container(1)
add(co, 1, b = 2, c = container(1:3))

s = setnew(1)
add(s, 1, 1, b = 2, "1", co = container(1, 1))

d = dict(a = 1)
add(d, b = 2, co = container(1:3))

try(add(d, a = 7:9))  # key 'a' already in Dict

dit = dict.table(a = 1:3)
add(dit, b = 3:1, d = 4:6)

try(add(dit, a = 7:9))  # column 'a' already exists

dit = dict.table(a = 1:3)
add(dit, b = 3:1, d = 4:6)

try(add(dit, a = 7:9))  # column 'a' already exists
}
