% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact_matrix.R
\name{contact_matrix}
\alias{contact_matrix}
\title{Get contact data matrix for a specific country}
\usage{
contact_matrix(
  country,
  location = c("all", "home", "school", "work", "other"),
  geographic_setting = c("all", "rural", "urban"),
  data_source = c("2020", "2017")
)
}
\arguments{
\item{country}{Character. The name of the country for which you want contact
data.}

\item{location}{Character. One of "all" (default), "home", "school", "work"
or "other".}

\item{geographic_setting}{Character. One of "all" (default), "rural", "urban"}

\item{data_source}{Character. Either "202O" (default) or "2017"}
}
\value{
A square (16 by 16) matrix containing the contact data between
the different age classes for a given country.
}
\description{
Get contact data matrix for a specific country
}
\examples{
contact_matrix("France", location = "all")

contact_matrix("Belgium", location = "school")

}
\references{
Kiesha Prem, Alex R. Cook, Mark Jit, \emph{Projecting social contact
matrices in 152 countries using contact surveys and demographic data}, PLoS
Comp. Biol. (2017), \doi{10.1371/journal.pcbi.1005697}

Kiesha Prem, Kevin van Zandvoort, Petra Klepac, Rosalind M. Eggo,
Nicholas G. Davies, CMMID COVID-19 Working Group, Alex R. Cook, Mark Jit,
\emph{Projecting contact matrices in 177 geographical regions: An update and
comparison with empirical data for the COVID-19 era}, PLoS Comp. Biol.
(2021), \doi{10.1371/journal.pcbi.1009098}.
}
