% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat2cov.R
\name{dat2cov}
\alias{dat2cov}
\title{conversion of a covariate dataset into summary covariate values}
\usage{
dat2cov(
  x,
  FUN = "mean",
  ...,
  notobs = 0,
  katorder = FALSE,
  caseorder = TRUE,
  wgt = NULL
)
}
\arguments{
\item{x}{an object of class "data.frame" with at least 2 \code{factor} variables representing the pattern (configurations) and at least 1 \code{numeric} variable representing the covariate(s).}

\item{FUN}{a function to compute the summary statistics which can be applied to all covariate variables in \code{x}. See function \code{\link[stats]{aggregate}}.}

\item{...}{further arguments passed to or used by methods in \code{FUN}.}

\item{notobs}{a numeric vector possibly with length equal to the number of \code{numeric} variables in \code{x}, defining the summary value for the respective covariate variable to use for unobserved pattern (configurations) defined by the \code{factor} variables in \code{x}. By default it is assumed that this value is 0. \code{notobs} is recycled if only one value is given.}

\item{katorder}{see \code{\link{dat2fre}}}

\item{caseorder}{see \code{\link{dat2fre}}}

\item{wgt}{a numerical vector of survey weights to weight the cases (rows) in \code{x}}
}
\value{
An object of class \code{c("data.frame", "Pcov")} holding the summary statistics for the covariate variables corresponding to the pattern (configurations) of the given dataset in the argument \code{x}.
}
\description{
Given a dataset \code{x}, this function returns summary values for some (\code{numeric}) covariate variables in \code{x} for each pattern (configuration) defined by a set of factor variables in \code{x}.
}
\details{
No further details
}
\keyword{utilities}
