% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch.R
\name{fetch.config}
\alias{fetch.config}
\title{Fetch configuration file and generate a merged list}
\usage{
fetch.config(
  links,
  return.files = FALSE,
  destdir = normalizePath("./"),
  keep.basename = TRUE,
  ...
)
}
\arguments{
\item{links}{Url or files path that need to be merged, 
e.g. /tmp/config, http://, ftp://.}

\item{return.files}{Only save the links configuration files to destdir 
and not to read and merge the configuration files, default is FALSE}

\item{destdir}{Fetch configuration files and copy to this directory, 
default is ./}

\item{keep.basename}{Whather use the links basename as the saved name 
or use paste0(tempfile(), '_configr')}

\item{...}{Extra parameters pass to \code{read.config}}
}
\value{
A list or a vector
}
\description{
Fetch configuration file and generate a merged list
}
\examples{
links <- c(paste0('https://raw.githubusercontent.com/JhuangLab', 
'/BioInstaller/master/inst/extdata/config/db/db_annovar.toml'), 
paste0('https://raw.githubusercontent.com/JhuangLab/BioInstaller', 
'/master/inst/extdata/config/db/db_main.toml'), 
system.file('extdata', 'config.toml', package = 'configr'))
x <- fetch.config(links)
}
