% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publication.R
\name{publication}
\alias{publication}
\title{Generate publication}
\usage{
publication(title, related_staff, link, citation, date)
}
\arguments{
\item{title}{Title of the publication.}

\item{related_staff}{Vector of the \code{id}s of the related staff.}

\item{link}{URL of the publication that will be linked.}

\item{citation}{Text that will be displayed for this publication.}

\item{date}{Date of publication. List of publications is sorted on the staff pages.}
}
\value{
An object of class \code{publication} with 5 elements:
\itemize{
\item \code{title}
\item \code{related_staff}
\item \code{link}
\item \code{citation}
\item \code{date}
}
}
\description{
Generates a publication object that is linked from staff websites
}
\examples{
example_publication <- publication(
    title = "Joe's Blogging Paper",
    related_staff = c("joe-bloggs"),
    link = NA,
    citation = "Bloggs, J., Bloggy, Y. (2019),
         The power of blogging, Australian Journal of Bloggs, 43: 149-155.",
    date = as.Date("2019-01-01")
)
}
