% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalized_mean.R
\name{hmean}
\alias{hmean}
\alias{hmean.default}
\title{Harmonic Mean}
\usage{
hmean(x, ...)

\method{hmean}{default}(x, trim = 0, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An \R object. Currently there are methods for numeric/logical
vectors and date, date-time and time interval objects. Complex vectors
are allowed for \code{trim = 0}, only.}

\item{...}{further arguments passed to or from other methods.}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed from each
end of \code{x} before the mean is computed. Values of trim outside that range
are taken as the nearest endpoint.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}
}
\value{
If \code{trim} is zero (the default), the harmonic mean of the values
in \code{x} is computed, as a numeric or complex vector of length one. If \code{x}
is not logical (coerced to numeric), numeric (including integer) or
complex, \code{NA_real_} is returned, with a warning.

If \code{trim} is non-zero, a symmetrically trimmed mean is computed with a
fraction of trim observations deleted from each end before the mean
is computed.
}
\description{
Harmonic Mean
}
\examples{
x <- c(1:10, 50)
xm <- hmean(x)

}
\seealso{
\code{\link{mean}} for the arithmetic mean and \code{\link{gmean}} for the geometric
mean.
}
