% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{palette_set}
\alias{palette_set}
\title{Make an HCL palette for visualizing an unordered set of distributions}
\usage{
palette_set(x, custom_hues)
}
\arguments{
\item{x}{RasterStack or integer describing the number of layers for which
colors need to be generated.}

\item{custom_hues}{vector of integers between -360 and 360 representing
hues in the color wheel. For further details, consult the documentation
for \link[colorspace:rainbow_hcl]{colorspace::rainbow_hcl}. The length of the vector must equal the
number of layers described by \code{x}. Hues are assigned to layers in order.}
}
\value{
A data frame with three columns:
\itemize{
\item \code{layer_id}: integer identifying the layer containing the maximum
intensity value; mapped to hue.
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
}
}
\description{
This function generates an HCL palette for visualizing a small
set of distributions (i.e., eight or fewer) that are not ordered in a
linear or cyclical sequence (e.g., a set of utilization distributions
describing space use by five separate individuals in the same population or
a set of four species distributions that depend on similar food resources).
}
\examples{
# load elephant data
data(elephant_ud)

# generate hcl color palette
pal <- palette_set(elephant_ud)
head(pal)

# visualize the palette in HCL space with colorspace::hclplot
library(colorspace)
hclplot(pal[pal$specificity == 100, ]$color)
}
\seealso{
\link{palette_timecycle} for cyclical sequences of distributions and
\link{palette_timeline} for linear sequences of distributions.

Other palette: 
\code{\link{palette_timecycle}()},
\code{\link{palette_timeline}()}
}
\concept{palette}
