% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensearch.R
\name{colocalized}
\alias{colocalized}
\title{Colocalized cluster search.}
\usage{
colocalized(choose, chr, n, cores)
}
\arguments{
\item{choose}{List of .bed tables}

\item{chr}{Chromosome}

\item{n}{The cut-off distance}

\item{cores}{Number of cores for parallel processing. Leaving this blank causes the program to use default (series) processing}
}
\value{
Table of clusters found in \code{chr}
}
\description{
Searches for clusters of colocalized transcription factor (TF) binding sequences.
\code{colocalized(choose,chr,n)} searches for instances where the sequences from each
table element in choose are colocalized to within a cut-off distance.
}
\examples{
complex<-list(nfkb1,nfkb2,relb)
colocalized(complex,"chrY",150)
}
