% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colf_nlxb.R
\name{colf_nlxb}
\alias{colf_nlxb}
\title{Nash Variant of the Marquardt algorithm on a linear objective function}
\usage{
colf_nlxb(formula, data, start = NULL, trace = FALSE, lower = -Inf,
  upper = Inf, na.action = c("na.omit", "na.fail", "na.exclude"),
  masked = NULL, control = NULL, ...)
}
\arguments{
\item{formula}{The formula. This has the same syntax and supports the same features as the 
formula in \code{lm}. See examples.}

\item{data}{A data frame containing the data of the variables in the formula.}

\item{start}{An atomic vector of same length as the number of parameters. If not provided a 
cheap guess will be made. If categorical variables are included these need to be takent into 
consideration as number of categories minus one. See examples and details.}

\item{trace}{Logical. Defaults to FALSE. Set to TRUE if you want the intermediate progress to be 
reported}

\item{lower}{Lower bounds of the parameters (atomic vector). If a single number, this will be 
applied to all parameters. Defaults to -Inf (unconstrained).}

\item{upper}{Upper bounds of the parameters (atomic vector). If a single number, this will be 
applied to all parameters. Defaults to Inf (unconstrained).}

\item{na.action}{A function which indicates what should happen if NAs are present in the data
set. Defaults to options('na.action'). na.fail, or na.exclude can be used.}

\item{masked}{Character vector of parameter names. These parameters will not be altered 
by the algorithm.}

\item{control}{A list of controls for the algorithm. These are:
\itemize{
  \item watch - Monitor progress. Logical, defaults to FALSE
  \item phi - Adds phi*identity to Jacobian inner product. Defaults to 1.
  \item lamda - Initial Marquardt adjustment. Defaults to 0.0001.
  \item offset - Shift to test floating point equality. Defaults to 100.
  \item laminc - Factor to use to increase lamda. Defaults to 10.
  \item lamdec - Factor to use to decrease lamda (lamdec / laminc). Defaults to 4.
  \item femax - Maximum evaluations of sum of squares function. Defaults to 10000.
  \item jemax - Maximum evaluations of the Jacobian. Defaults to 5000.
  \item rofftest - Use a termination of the relative offset orthogonality type. 
  \item smallsstest - Exit the function if the sum of squares falls below 
  (100 * .Machine$double.eps)^4 times the initial sumsquares. Defaults to TRUE.
}}

\item{...}{Other arguments passed on to optimiser}
}
\value{
Same as nlxb
}
\description{
Non linear least squares solution via qr linear solver on a linear objective function.
}
\details{
\code{colf_nlxb} uses Nash's (Nash, 1979) variant of the Marquardt algorithm, in an attempt to
find the minimum of the residual sum of squares. The algorithm is applied on a linear objective
function.

The function provides an easy way to apply the optimizer on a linear objective function in a 
similar way to \code{lm}.

start, lower and upper, if provided, can be either an atomic vector which has the same length as
the number of parameters or a single number which will be replicated to match the length of the 
parameters. If categorical variables exist in the function these will be dummified. Out of one
categorical variable, n - 1 will be created where n is the total number of categories in the 
variable. This needs to be taken into account when providing an atomic vector for start, lower or
upper. Also, as with \code{lm} an intercept will be added which also needs to be taken into 
account.
}
\examples{
#no constraints
colf_nlxb(mpg ~ cyl + disp, mtcars)

#no intercept
colf_nlxb(mpg ~ 0 + cyl + disp, mtcars)

#including categorical variables. These will be dummified.
colf_nlxb(Sepal.Length ~ Sepal.Width + Species, iris)

#lower boundary will be replicated for all parameters 
colf_nlxb(Sepal.Length ~ Sepal.Width + Species, iris, lower = 0.5)

#species is categorical and contains 3 categories, thus we need to specify 4 lower bounds:
#the first one for the intercept.
#the second one for Sepal.Width 
#the two next for the dummy variables constructed from Species. 
colf_nlxb(Sepal.Length ~ Sepal.Width + Species, iris, lower = rep(0.5, 4))

}
\seealso{
\link[nlsr]{nlxb}
}

