% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognito_add_account.R
\name{cognito_add_account}
\alias{cognito_add_account}
\title{Allow create an user in Cognito Pool}
\usage{
cognito_add_account(
  cognito_config,
  Username,
  UserAttributes,
  DesiredDeliveryMediums,
  ...
)
}
\arguments{
\item{cognito_config}{- Cognito Config list}

\item{Username}{- Username to use in Cognito - This can be a username, email ,phone depending configuration
in Amazon Pool.}

\item{UserAttributes}{- User attributes: This can be multiples attributes, depends of configuration in Amazon Pool.}

\item{DesiredDeliveryMediums}{- Medium to delivert email when user is created, can be EMAIL or SMS}

\item{...}{extra params to pass to method paws::admin_create_user}
}
\value{
boolean
}
\description{
This method is working with amazing package "paws" , so you need to have the required AWS secret and access key (see example).
}
\details{
Also needs to have the config for cognitoR. Specially the pool Id (group_id in config),
where the new user is created.
}
\examples{
\dontrun{
Sys.setenv(
AWS_ACCESS_KEY_ID = '',
AWS_SECRET_ACCESS_KEY = '',
AWS_REGION = ''
)
cognito_add_account("account@mail.com",
                    UserAttributes = list(list(Name = "email", Value = "account@mail.com"),
                                          list(Name = "phone_number", Value = "+12123212312321")
                                     ),
                    DesiredDeliveryMediums = "EMAIL"
                    )
}
}
