% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{data.ggCMap}
\alias{data.ggCMap}
\title{Data collection for ggCMap}
\usage{
data.ggCMap(
  project,
  min.weight = 1,
  filters = NULL,
  units = "all",
  weighted.icm = FALSE,
  label = "name",
  minlen = 1,
  fontsize = 16,
  shape = "box",
  layoutType = "neato",
  vertex.filter = NULL,
  edge.filter = NULL,
  limit.to.filters = FALSE,
  level = 0
)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{min.weight}{A integer that will determine the minimum (>=) weight of relationships that will be taken into account. Relationships with a lower weight (<) will not be shown. Default is set to 1 (\emph{i.e.} all relationships are shown).}

\item{filters}{A list of named strings that will filter the relationships showed in the SCM. e.g. =list(coding_class = "A_coding_class", document_part = "A_document_part")=. To date, these filters are linked to the nature of relationships.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}

\item{weighted.icm}{A boolean. If FALSE, the weight of the relationships in the ICM will be fixed to 1.}

\item{label}{A character string that defines the text that will be print in the variables (vertex) of the cognitive maps. It can be "num", "name" or "numname" (which is of the form "NUM - Name"). The default is "num"}

\item{minlen}{A graphical parameter that defines a relative length between the variable of the cognitive maps. See help from RGraphViz package.}

\item{fontsize}{The fontsize of vertices (concepts), in r-base plot}

\item{shape}{The shape of the vertices (concepts), in r-base plot}

\item{layoutType}{Type of graph. See detail in RGraphViz. Can be 'neato', 'dot', 'twopi', 'circo', and 'fdp'. The default is 'neato'.}

\item{vertex.filter}{A vector of integers or characters given the 'id' of vertices (concepts) that will be included in the map. By default, all vertices are included (vertex.filter = NULL)}

\item{edge.filter}{A vector of characters given the name "i~j" of edges (relationships from "i" to "j") that will be included in the map. By default, all edges are included (edge.filter = NULL)}

\item{limit.to.filters}{A logical that will impact the position of the vertices. FALSE (the default) will filter vertices and edges (vertex.filter, edge.filter) keeping the position they would have in the unfiltered cognitive map (interesting with background). TRUE will fully re-compute the position of the vertices, building a cognitive map in its own (better readability).}

\item{level}{0 or 1. Filter the edge/vertices at x level around the filtered edges/vertices (==Not implemented yet==)}
}
\value{
A list of two data frames :
-edges
-vertex.
In each of these data frames, the main columns are linked to the coordinates of vertex (x, y, x.from, y.from, x.to, y.to)
}
\description{
Get all important data for plotting a Cognitive Map in ggplot
}
\details{
Get all important data for plotting a Cognitive Map in ggplot
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

data.ggCMap(my.project)
data.ggCMap(my.project, min.weight = 3)
data.ggCMap(my.project, edge.filter = "4")
data.ggCMap(my.project, units = "Belgium")
}
