% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl_levels.R
\name{cl_levels}
\alias{cl_levels}
\title{Get the hierarchical level for each code in a code list}
\usage{
cl_levels(codelist)
}
\arguments{
\item{codelist}{the \code{\link{codelist}} for which to determine the levels.}
}
\value{
An integer vector with the same length as the number of rows in the code
list.
}
\description{
Get the hierarchical level for each code in a code list
}
\details{
Levels are numbered with 0 being the top-most level, which contains code
without parent (parent missing). In level 1 are codes that have a parent in
level 0. Etc.

When the code list does not have a 'parent' column, all codes are in level 0.
}
\examples{
data(objectcodes)
cl_levels(objectcodes)

}
