% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.label.R
\name{as.label}
\alias{as.label}
\title{Label character vector as label to use in comparisons with a code vector}
\usage{
as.label(x)
}
\arguments{
\item{x}{character vector that is to be interpreted as a label. If \code{x}
is not a character vector it will be converted to one using
\code{as.character}.}
}
\value{
Returns a character vector with the class "label". This can be used in
comparisons to a 'code' vector, or to assign to a 'code' vector.
}
\description{
Label character vector as label to use in comparisons with a code vector
}
\examples{
data(objectcodes)
data(objectsales)
objectsales$product <- code(objectsales$product, objectcodes)

objectsales$product[1] <- as.label("Hammer")

objectsales$product == as.label("Hammer")
subset(objectsales, product == as.label("Hammer"))

# This is the same as
subset(objectsales, product == codes("Hammer", cl(product)))

}
\seealso{
Uses \code{\link{codes}}.
}
