% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_delta_comp.R
\name{plot_delta_comp}
\alias{plot_delta_comp}
\title{Plot redistributed time-use predictions from compositional ilr multiple linear regression model fit}
\usage{
plot_delta_comp(dc_obj, comp_total = NULL, units_lab = NULL)
}
\arguments{
\item{dc_obj}{A \code{deltacomp_obj} object returned from the function \code{predict_delta_comps}}

\item{comp_total}{A numeric scalar that is the original units of the composition to make the x-axis the original scale instead of in the range \code{[min(delta), max(delta)]} in (-1, 1).}

\item{units_lab}{Character string of the units of the compositions relating to \code{comp_total} to add to the x-axis label}
}
\value{
Returns a plot object from the \code{ggplot2} package (that is, class of \code{gg} and \code{ggplot}).
}
\description{
Plot redistributed time-use predictions from compositional ilr multiple linear regression model fit by \code{predict_delta_comps()}
}
\examples{
data(fairclough)

deltacomp_df <-
  predict_delta_comps(
    dataf = fairclough,
    y = "z_bmi",
    comps = c("sleep","sed","lpa","mvpa"),
    covars = c("decimal_age","sex"),
    deltas =  seq(-20, 20, by = 5) / (24 * 60),
    comparisons = "prop-realloc",
    alpha = 0.05
  )
class(deltacomp_df)

plot_delta_comp(
  dc_obj = deltacomp_df,
  comp_total = 24 * 60,
  units_lab = "min"
)

deltacomp_df <-
  predict_delta_comps(
    dataf = fairclough,
    y = "z_bmi",
    comps = c("sleep","sed","lpa","mvpa"),
    covars = c("decimal_age","sex"),
    deltas =  seq(-20, 20, by = 5) / (24 * 60),
    comparisons = "one-v-one",
    alpha = 0.05
  )

plot_delta_comp(
  dc_obj = deltacomp_df,
  comp_total = 24 * 60,
  units_lab = "min"
)
}
\author{
Ty Stanford <tystan@gmail.com>
}
