% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silhouette.R
\name{maximiseSilhouette}
\alias{maximiseSilhouette}
\title{Choose K that maximises the silhouette from a set of kernel matrices and
clusterings}
\usage{
maximiseSilhouette(
  kernelMatrix,
  clLabels,
  maxK,
  savePNG = FALSE,
  fileName = "silhouette",
  isDistance = FALSE,
  widestGap = FALSE,
  dunns = FALSE,
  dunn2s = FALSE
)
}
\arguments{
\item{kernelMatrix}{N X N X (maxK-1) array of kernel matrices.}

\item{clLabels}{(maxK-1) X N matrix containing the clusterings obtained for
different values of K.}

\item{maxK}{Maximum number of clusters considered.}

\item{savePNG}{If TRUE, a plot of the silhouette is saved in the working
folder. Defaults to FALSE.}

\item{fileName}{If \code{savePNG} is TRUE, this is the name of the png file.}

\item{isDistance}{Boolean. If TRUE, the kernel matrices are interpreted as
matrices of distances, otherwise as matrices of similarities.}

\item{widestGap}{Boolean. If TRUE, also computes widest gap index (and plots
it if \code{savePNG} is TRUE).}

\item{dunns}{Boolean. If TRUE, also computes Dunn's index: minimum separation
/ maximum diameter (and plots it if \code{savePNG} is TRUE).}

\item{dunn2s}{Boolean. If TRUE, also computes an alternative version
of Dunn's index: minimum average dissimilarity between two cluster / maximum
average within cluster dissimilarity (and plots it if \code{savePNG} is
TRUE).}
}
\value{
The function returns a list containing:
\item{silh}{a vector of length \code{maxK-1} such that \code{silh[i]} is the
silhouette for \code{K = i+1}}
\item{K}{the lowest number of clusters for which the silhouette is
maximised.}
}
\description{
Choose the number of clusters K that maximises the silhouette, starting from
a set of kernel matrices each corresponding to a different choice of K and
the corresponding clusterings of the data for each of those values of K.
}
\author{
Alessandra Cabassi \email{alessandra.cabassi@mrc-bsu.cam.ac.uk}
}
