% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msms-search.R
\name{msms_search}
\alias{msms_search}
\title{MS/MS Search using CEU Mass Mediator API}
\usage{
msms_search(
  ion_mass,
  ms_ms_peaks,
  precursor_ion_tolerance = 100,
  precursor_ion_tolerance_mode = "mDa",
  precursor_mz_tolerance = 500,
  precursor_mz_tolerance_mode = "mDa",
  ion_mode,
  ionization_voltage = "all",
  spectra_types = "experimental",
  cmm_url = "https://ceumass.eps.uspceu.es/api/msmssearch"
)
}
\arguments{
\item{ion_mass}{Numeric. Mass of the ion to search for.}

\item{ms_ms_peaks}{Matrix. The MS/MS peaks, with two columns representing mass and intensity.}

\item{precursor_ion_tolerance}{Numeric. Tolerance for the precursor ion (default: 100.0).}

\item{precursor_ion_tolerance_mode}{Character. Tolerance mode for precursor ion: \code{"ppm"} or \code{"mDa"} (default: "mDa").}

\item{precursor_mz_tolerance}{Numeric. Tolerance for the m/z (default: 500.0).}

\item{precursor_mz_tolerance_mode}{Character. Tolerance mode for precursor m/z: \code{"ppm"} or \code{"mDa"} (default: "mDa").}

\item{ion_mode}{Character. Ionization mode: \code{"positive"} or \code{"negative"}.}

\item{ionization_voltage}{Character. Ionization voltage to use (default: "all").}

\item{spectra_types}{Character. Spectra types: \code{"experimental"} or other supported types.}

\item{cmm_url}{Character. URL for the CEU Mass Mediator API (default: "https://ceumass.eps.uspceu.es/api/msmssearch").}
}
\value{
A dataframe containing the search results from the CEU Mass Mediator API.
}
\description{
\code{msms_search} performs an MS/MS search on the CEU Mass Mediator API
and returns a dataframe with the search results.
}
\examples{
\dontrun{
ms_ms_peaks <- matrix(
  c(
    40.948, 0.174,
    56.022, 0.424,
    84.370, 53.488,
    101.500, 8.285,
    102.401, 0.775,
    129.670, 100.000,
    146.966, 20.070
  ),
  ncol = 2,
  byrow = TRUE
)

df <- msms_search(
  ion_mass = 147,
  ms_ms_peaks = ms_ms_peaks,
  ion_mode = "positive"
)
}
}
