% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch-search-advanced.R
\name{advanced_batch_search}
\alias{advanced_batch_search}
\title{Advanced Batch Search using CEU Mass Mediator API}
\usage{
advanced_batch_search(
  cmm_url = "https://ceumass.eps.uspceu.es/api/v3/advancedbatch",
  chemical_alphabet = "ALL",
  modifiers_type = "none",
  metabolites_type = "all-except-peptides",
  databases = "[\\"HMDB\\"]",
  masses_mode = "mz",
  ion_mode = "positive",
  adducts = "[\\"all\\"]",
  deuterium = FALSE,
  tolerance = 7.5,
  tolerance_mode = "ppm",
  masses = NULL,
  all_masses = "[]",
  retention_times = NULL,
  all_retention_times = "[]",
  composite_spectra = NULL
)
}
\arguments{
\item{cmm_url}{A character string specifying the CEU Mass Mediator API endpoint.
Default is \code{"https://ceumass.eps.uspceu.es/api/v3/advancedbatch"}.}

\item{chemical_alphabet}{A character string specifying the chemical alphabet to use.
Options are \code{"CHNOPS"}, \code{"CHNOPSCL"}, or \code{"ALL"}.}

\item{modifiers_type}{A character string specifying the modifier type.
Options are \code{"none"}, \code{"NH3"}, \code{"HCOO"}, \code{"CH3COO"}, \code{"HCOONH3"}, or \code{"CH3COONH3"}.}

\item{metabolites_type}{A character string specifying the metabolites type.
Options are \code{"all-except-peptides"}, \code{"only-lipids"}, or \code{"all-including-peptides"}.}

\item{databases}{A JSON-formatted character string specifying the databases to search.
Examples include \code{'["all"]'}, \code{'["HMDB"]'}, \code{'["LipidMaps"]'}.}

\item{masses_mode}{A character string specifying the masses mode. Options are \code{"neutral"} or \code{"mz"}.}

\item{ion_mode}{A character string specifying the ionization mode. Options are \code{"positive"}, \code{"negative"}, or \code{"neutral"}.}

\item{adducts}{A JSON-formatted character string specifying the adducts to include in the search.
Examples include \code{'["M+H","M+Na"]'} for positive mode.}

\item{deuterium}{A logical value indicating whether to consider deuterium substitutions. \code{TRUE} or \code{FALSE}.}

\item{tolerance}{A numeric value specifying the mass tolerance (Range: \code{0} to \code{100}).}

\item{tolerance_mode}{A character string specifying the tolerance mode. Options are \code{"ppm"} or \code{"mDa"}.}

\item{masses}{A numeric vector of masses to search.}

\item{all_masses}{A JSON-formatted character string representing an array of mass arrays.}

\item{retention_times}{A numeric vector of retention times corresponding to the masses.}

\item{all_retention_times}{A JSON-formatted character string representing an array of retention time arrays.}

\item{composite_spectra}{A JSON-formatted character string representing composite spectra.}
}
\value{
A dataframe containing the search results from the CEU Mass Mediator API.
}
\description{
\code{advanced_batch_search} performs an advanced batch search on the CEU Mass Mediator API
and returns a dataframe of search results.
}
\examples{
\dontrun{
df <- advanced_batch_search(
  cmm_url = "https://ceumass.eps.uspceu.es/api/v3/advancedbatch",
  chemical_alphabet = "ALL",
  modifiers_type = "none",
  metabolites_type = "all-except-peptides",
  databases = '["HMDB"]',
  masses_mode = "mz",
  ion_mode = "positive",
  adducts = '["all"]',
  deuterium = FALSE,
  tolerance = 7.5,
  tolerance_mode = "ppm",
  masses = c(400.3432, 288.2174),
  all_masses = "[]",
  retention_times = c(18.842525, 4.021555),
  all_retention_times = "[]",
  composite_spectra = paste0(
    '[ [ { "mz": 400.3, "intensity": 307034.9 },',
    '   { "mz": 311.2, "intensity": 400.1 } ] ]'
  )
)
}
}
