## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)

## ----setup--------------------------------------------------------------------
library(cld)

## ----reversed-----------------------------------------------------------------
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)

# Default ordering
make_cld(result)

# Reversed ordering
make_cld(result, reversed = TRUE)

## ----swap-names, eval=FALSE---------------------------------------------------
# # Swap the order of compared groups
# make_cld(result, swap_compared_names = TRUE)

## ----print-comp, eval=FALSE---------------------------------------------------
# # Print comparison names during processing
# make_cld(result, print_comp = TRUE)

## ----string-cleaning, eval=FALSE----------------------------------------------
# # Remove spaces from comparison strings
# make_cld(df, remove_space = TRUE)
# 
# # Replace colons with hyphens
# make_cld(df, swap_colon = TRUE)
# 
# # Remove equal signs
# make_cld(df, remove_equal = TRUE)
# 
# # Replace "vs" with hyphens
# make_cld(df, swap_vs = TRUE)

