% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval_matrix_to_df.R
\name{pval_matrix_to_df}
\alias{pval_matrix_to_df}
\title{Convert matrix with p-values to data frame}
\usage{
pval_matrix_to_df(x)
}
\arguments{
\item{x}{A numeric matrix containing p-values. If the matrix has no column or row names,
they will be assigned sequential numbers. The matrix can be symmetric (with diagonal
and upper/lower triangle) or triangular. \code{NA} values are removed from the output.}
}
\value{
A data frame of class \code{c("pairwise_pval_df", "data.frame")} with columns:
\itemize{
\item \code{gr1} - names from the columns of the matrix
\item \code{gr2} - names from the rows of the matrix
\item \code{p_values} - the corresponding p-values from the matrix (excluding \code{NA} values)
}
}
\description{
This function converts a matrix of p-values into a data frame with three columns:
\code{gr1} (column names), \code{gr2} (row names), and \code{p_values} (the p-values).
This is particularly useful when you have a symmetric matrix of p-values from
pairwise comparisons and need to convert it to a long-format data frame for
further analysis or for use with \code{\link[=make_cld]{make_cld()}}.
}
\examples{
# Create a matrix of p-values
m <- matrix(c(NA, 0.05, 0.01, 0.05, NA, 0.03, 0.01, 0.03, NA), nrow = 3)
colnames(m) <- c("A", "B", "C")
rownames(m) <- c("A", "B", "C")

# Convert to data frame
cld::pval_matrix_to_df(m)
}
\seealso{
\itemize{
\item \code{\link[=make_cld]{make_cld()}} for creating compact letter displays from the resulting data frame
\item \code{\link[=as_cld]{as_cld()}} for converting other formats to cld_object
}

Other helper functions: 
\code{\link{as_cld}()}

Other data conversion functions: 
\code{\link{as_cld}()}
}
\concept{data conversion functions}
\concept{data_conversion}
\concept{helper functions}
\concept{helper_functions}
\keyword{manip}
