% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spc.R
\name{spc}
\alias{spc}
\title{spatial pattern correlation}
\usage{
spc(
  data,
  overlay = "and",
  discnum = 3:8,
  discmethod = c("sd", "equal", "geometric", "quantile", "natural"),
  cores = 1
)
}
\arguments{
\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{overlay}{(optional) Spatial overlay method. One of \code{and}, \code{or}, \code{intersection}.
Default is \code{and}.}

\item{discnum}{(optional) A vector of number of classes for discretization. Default is \code{3:8}.}

\item{discmethod}{(optional) A vector of methods for discretization, default is using
\code{c("sd","equal","geometric","quantile","natural")} by invoking \code{sdsfun}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1,
use parallel computing.}
}
\value{
A list.
\describe{
\item{\code{cor_tbl}}{A tibble with power of spatial pattern correlation}
\item{\code{cor_mat}}{A matrix with power of spatial pattern correlation}
}
}
\description{
spatial pattern correlation
}
\examples{
sim1 = sf::st_as_sf(gdverse::sim,coords = c('lo','la'))
sim1
\donttest{
g = spc(sim1, discnum = 3:6, cores = 1)
g
plot(g,"matrix")
}
}
