% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\docType{class}
\name{ccGenomicTrack-class}
\alias{ccGenomicTrack-class}
\title{S4 class ccGenomicTrack}
\description{
S4 class ccGenomicTrack
}
\section{Slots}{

\describe{
\item{\code{func}}{character. Normally it is "circos.genomicTrack" or "circos.genomicIdeogram" or "circos.genomicHeatmap" or "circos.genomicLabels" or"circos.genomicRainfall" or "circos.genomicDensity".}

\item{\code{params}}{list. A \strong{named} list that stores the parameters of the function called by the backend.}

\item{\code{trackGeoms}}{list. A list where \linkS4class{ccTrackGeom} are stored.}

\item{\code{cells}}{list. A list where \linkS4class{ccCell} are stored.}
}}

\examples{
library(circlizePlus)
cc = ccPlot(initMode = "initializeWithIdeogram",chromosome.index = "chr1", plotType = NULL)
bed = generateRandomBed(nr = 300)
t1 = ccGenomicTrack(bed, panel.fun = function(region, value, ...) {
  circos.genomicPoints(region, value, pch = 16, cex = 0.5, ...)
})
cc+t1
circos.clear()
}
