% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubblebath.R
\name{bubblebath}
\alias{bubblebath}
\title{Generate Bubble Bath (Chart) Dataframe}
\usage{
bubblebath(
  frameSize = c(50, 50),
  circSize = seq(0.2, 5, length.out = 25),
  maxCircsPerRad = 10000,
  max_iter = 10000,
  density = 0.7,
  overlap = FALSE,
  suppressWarning = FALSE
)
}
\arguments{
\item{frameSize}{A numeric vector of length 2 defining the frame's width and height (centered at 0).}

\item{circSize}{A numeric vector specifying the radii of circles to place.
If length is 2, it's interpreted as min and max for a sequence.
If length > 2, the exact values are used as radii.}

\item{maxCircsPerRad}{Maximum number of circles per radius.}

\item{max_iter}{Maximum attempts to place each circle.}

\item{density}{Density of circles, between 0 and 1.}

\item{overlap}{Logical; if FALSE, circles won't overlap.}

\item{suppressWarning}{Logical; if TRUE internal warnings are suppressed.}
}
\value{
A data frame with columns x, y, and r (circle centers and radii).
}
\description{
Creates a dataset of circles ("bubbles") with random centers and specified radii.
When overlap is FALSE, circles are placed so they do not overlap.
}
\examples{
# Create bubble bath points
circles <- bubblebath(circSize = c(0.5, 1, 2, 3), overlap = FALSE)
}
