% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/railfence.R
\name{railfence}
\alias{railfence}
\title{Encrypt or decrypt a Railfence Cipher}
\usage{
railfence(x, n = 1, decrypt = FALSE)
}
\arguments{
\item{x}{A vector to be encoded or decoded.}

\item{n}{(Default: \code{1}) The width of the rail to be used. A width of one will
have no effect.}

\item{decrypt}{(Default: \code{FALSE}) The default \code{FALSE} will encrypt while
using \code{TRUE} will decrypt a given value of \code{x}.}
}
\value{
A character vector of length one that has been transformed
}
\description{
This can be used to create (encrypt) and solve (decrypt) a
Railfence Cipher. A Railfence Cipher maps each letter to a cosine wave of
the specified height where each letter resides at an integer rail height.

The Railfence Cipher Wikipedia entry provides more information on the methods
used: \url{https://en.wikipedia.org/wiki/Rail_fence_cipher}
}
